package com.example.sefinsa_app.controllers;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

import com.example.sefinsa_app.migrations.ConfiguracionSemanasMigration;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.ConfiguracionSemana;
import com.example.sefinsa_app.models.Ruta;

import java.util.ArrayList;

public class ConfiguracionSemanasController {
    private final DatabaseHelper databaseHelper;

    private final String NOMBRE_TABLA = "configuracion_semanas";

    public ConfiguracionSemanasController(Context contexto) {
        databaseHelper = new DatabaseHelper(contexto);
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id integer primary key, " +
                        "cantidad int, " +
                        "interes text, " +
                        "tipo_abono text, " +
                        "semana_renovacion int, " +
                        "status int) "
                , NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);
    }

    public boolean tablaExiste() {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("select DISTINCT tbl_name from sqlite_master where tbl_name = '" + NOMBRE_TABLA+ "'", null);

        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.close();
                return true;
            }
            cursor.close();
        }
        return false;
    }


    public int eliminar(ConfiguracionSemana configuracionsemana) {

        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        String[] argumentos = {String.valueOf(configuracionsemana.getId())};
        return db.delete(NOMBRE_TABLA, "id = ?", argumentos);
    }

    public long nueva(ConfiguracionSemana configuracionsemana) {
        // writable porque vamos a insertar
        SQLiteDatabase db = databaseHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT id from configuracion_semanas where configuracion_semanas.id = " + configuracionsemana.getId(), null);

        if(cursor.moveToFirst()){
            return 0;
        }
        else{
            ContentValues valoresParaInsertar = new ContentValues();
            valoresParaInsertar.put("id", configuracionsemana.getId());
            valoresParaInsertar.put("cantidad", configuracionsemana.getCantidad());
            valoresParaInsertar.put("interes", configuracionsemana.getInteres());
            valoresParaInsertar.put("tipo_abono", configuracionsemana.getTipo_Abono());
            valoresParaInsertar.put("semana_renovacion", configuracionsemana.getSemana_Renovacion());
            valoresParaInsertar.put("status", configuracionsemana.getStatus());
            return db.insert(NOMBRE_TABLA, null, valoresParaInsertar);
        }


    }

    public void truncate(){
        SQLiteDatabase db = databaseHelper.getWritableDatabase();

        String TABLE_SCHEMA = String.format("CREATE TABLE IF NOT EXISTS %s(" +
                        "id integer primary key, " +
                        "cantidad int, " +
                        "interes text, " +
                        "tipo_abono text, " +
                        "semana_renovacion int, " +
                        "status int) "
                , NOMBRE_TABLA);

        db.execSQL("DROP TABLE IF EXISTS " + NOMBRE_TABLA);

        db.execSQL(TABLE_SCHEMA);

        Log.d("TRUNCATE",NOMBRE_TABLA);
    }

    public ArrayList<ConfiguracionSemana> obtener() {
        ArrayList<ConfiguracionSemana> configuracionsemana = new ArrayList<>();
        // readable porque no vamos a modificar, solamente leer
        SQLiteDatabase db = databaseHelper.getReadableDatabase();
        // SELECT nombre, edad, id
        String[] columnasAConsultar = {"id", "cantidad", "interes", "tipo_abono", "semana_renovacion", "status"};
        Cursor cursor = db.query(
                "configuracion_semanas",
                columnasAConsultar,
                null,
                null,
                null,
                null,
                "id DESC"
        );

        if (cursor == null) {
        /*
            Salimos aquí porque hubo un error, regresar
            lista vacía
            */
            return configuracionsemana;

        }
        // Si no hay datos, igualmente regresamos la lista vacía
        if (!cursor.moveToFirst()) return configuracionsemana;

        // En caso de que sí haya, iteramos y vamos agregando los
        // datos a la lista de mascotas
        do {
            // El 0 es el número de la columna, como seleccionamos
            // nombre, edad,id entonces el nombre es 0, edad 1 e id es 2
            String id = cursor.getString(0);
            String cantidad = cursor.getString(1);
            String interes = cursor.getString(2);
            String tipo_abono = cursor.getString(3);
            String semana_renovacion = cursor.getString(4);
            String status = cursor.getString(5);

            ConfiguracionSemana configuracionSemanasObtenidaDeBD = new ConfiguracionSemana(id, cantidad, interes, tipo_abono, semana_renovacion, status);
            configuracionsemana.add(configuracionSemanasObtenidaDeBD);
        } while (cursor.moveToNext());

        // Fin del ciclo. Cerramos cursor y regresamos la lista de mascotas :)
        cursor.close();
        return configuracionsemana;
    }

}
